@extends('layouts.app')
@include('components.offline_banner')

@section('title', __('sale.pos_sale'))

@section('content')
    <section class="content no-print">
        <input type="hidden" id="amount_rounding_method" value="{{ $pos_settings['amount_rounding_method'] ?? '' }}">
        @if (!empty($pos_settings['allow_overselling']))
            <input type="hidden" id="is_overselling_allowed">
        @endif
        @if (session('business.enable_rp') == 1)
            <input type="hidden" id="reward_point_enabled">
        @endif
        @php
            $is_discount_enabled = $pos_settings['disable_discount'] != 1 ? true : false;
            $is_rp_enabled = session('business.enable_rp') == 1 ? true : false;
        @endphp
        {!! Form::open([
            'url' => action([\App\Http\Controllers\SellPosController::class, 'store']),
            'method' => 'post',
            'id' => 'add_pos_sell_form',
        ]) !!}
        <div class="row mb-12">
            <div class="col-md-12 tw-pt-0 tw-mb-14">
                <div class="row tw-flex lg:tw-flex-row md:tw-flex-col sm:tw-flex-col tw-flex-col tw-items-start md:tw-gap-4">
                    {{-- <div class="@if (empty($pos_settings['hide_product_suggestion'])) col-md-7 @else col-md-10 col-md-offset-1 @endif no-padding pr-12"> --}}
                    <div class="tw-px-3 tw-w-full  lg:tw-px-0 lg:tw-pr-0 @if(empty($pos_settings['hide_product_suggestion'])) lg:tw-w-[60%]  @else lg:tw-w-[100%] @endif">

                        <div class="tw-shadow-[rgba(17,_17,_26,_0.1)_0px_0px_16px] tw-rounded-2xl tw-bg-white tw-mb-2 md:tw-mb-8 tw-p-2">

                            {{-- <div class="box box-solid mb-12 @if (!isMobile()) mb-40 @endif"> --}}
                                <div class="box-body pb-0">
                                    {!! Form::hidden('location_id', $default_location->id ?? null, [
                                        'id' => 'location_id',
                                        'data-receipt_printer_type' => !empty($default_location->receipt_printer_type)
                                            ? $default_location->receipt_printer_type
                                            : 'browser',
                                        'data-default_payment_accounts' => $default_location->default_payment_accounts ?? '',
                                    ]) !!}
                                    <!-- sub_type -->
                                    {!! Form::hidden('sub_type', isset($sub_type) ? $sub_type : null) !!}
                                    <input type="hidden" id="item_addition_method"
                                        value="{{ $business_details->item_addition_method }}">
                                    @include('sale_pos.partials.pos_form')

                                    @include('sale_pos.partials.pos_form_totals')

                                    @include('sale_pos.partials.payment_modal')

                                    @if (empty($pos_settings['disable_suspend']))
                                        @include('sale_pos.partials.suspend_note_modal')
                                    @endif

                                    @if (empty($pos_settings['disable_recurring_invoice']))
                                        @include('sale_pos.partials.recurring_invoice_modal')
                                    @endif
                                </div>
                            {{-- </div> --}}
                        </div>
                    </div>
                    @if (empty($pos_settings['hide_product_suggestion']) && !isMobile())
                        <div class="md:tw-no-padding tw-w-full lg:tw-w-[40%] tw-px-5">
                            @include('sale_pos.partials.pos_sidebar')
                        </div>
                    @endif
                </div>
            </div>
        </div>
        @include('sale_pos.partials.pos_form_actions')
        {!! Form::close() !!}
    </section>

    <!-- This will be printed -->
    <section class="invoice print_section" id="receipt_section">
    </section>
    <div class="modal fade contact_modal" tabindex="-1" role="dialog" aria-labelledby="gridSystemModalLabel">
        @include('contact.create', ['quick_add' => true])
    </div>
    @if (empty($pos_settings['hide_product_suggestion']) && isMobile())
        @include('sale_pos.partials.mobile_product_suggestions')
    @endif
    <!-- /.content -->
    <div class="modal fade register_details_modal" tabindex="-1" role="dialog" aria-labelledby="gridSystemModalLabel">
    </div>
    <div class="modal fade close_register_modal" tabindex="-1" role="dialog" aria-labelledby="gridSystemModalLabel">
    </div>
    <!-- quick product modal -->
    <div class="modal fade quick_add_product_modal" tabindex="-1" role="dialog" aria-labelledby="modalTitle"></div>

    <div class="modal fade" id="expense_modal" tabindex="-1" role="dialog" aria-labelledby="gridSystemModalLabel">
    </div>

    @include('sale_pos.partials.configure_search_modal')

    @include('sale_pos.partials.recent_transactions_modal')

    @include('sale_pos.partials.weighing_scale_modal')

@stop
@section('css')
    <!-- include module css -->
    @if (!empty($pos_module_data))
        @foreach ($pos_module_data as $key => $value)
            @if (!empty($value['module_css_path']))
                @includeIf($value['module_css_path'])
            @endif
        @endforeach
    @endif
@stop
@section('javascript')
    <script src="{{ asset('js/pos.min.js?v=' . $asset_v) }}" defer></script>
    <script src="{{ asset('js/printer.js?v=' . $asset_v) }}" defer></script>
    <script src="{{ asset('js/product.min.js?v=' . $asset_v) }}" defer></script>
    <script src="{{ asset('js/opening_stock.js?v=' . $asset_v) }}" defer></script>
    @include('sale_pos.partials.keyboard_shortcuts')

    <!-- Call restaurant module if defined -->
    @if (in_array('tables', $enabled_modules) ||
            in_array('modifiers', $enabled_modules) ||
            in_array('service_staff', $enabled_modules))
        <script src="{{ asset('js/restaurant.js?v=' . $asset_v) }}"></script>
    @endif
    <!-- include module js -->
    @if (!empty($pos_module_data))
        @foreach ($pos_module_data as $key => $value)
            @if (!empty($value['module_js_path']))
                @includeIf($value['module_js_path'], ['view_data' => $value['view_data']])
            @endif
        @endforeach
    @endif

    <script src="{{ asset('js/offline-sync.js') }}"></script>

    <script>
    // When price group changes after items are already added, refresh unit prices
    (function($){
        function refreshRowPrice($row, groupId){
            var variation_id = $row.find('.row_variation_id').val();
            var location_id  = $('#location_id').val();
            if(!variation_id || !location_id) return;

            var is_direct_sell = ($('input[name="is_direct_sale"]').val() === '1');
            var is_sales_order = ($('#sale_type').length && $('#sale_type').val() === 'sales_order');
            var disable_qty_alert = $('#disable_qty_alert').length ? true : false;
            var is_draft = ($('input#status').length && ( $('input#status').val()==='quotation' || $('input#status').val()==='draft'));

            var endpointBase = "{{ url('/sells/pos/get_product_row') }}"; // respects app base path (/test)
            $.ajax({
                method: 'GET',
                url: endpointBase + '/' + variation_id + '/' + location_id,
                data: {
                    product_row: 0,
                    customer_id: $('#customer_id').val(),
                    is_direct_sell: is_direct_sell ? 1 : 0,
                    price_group: groupId || '',
                    quantity: 1,
                    is_sales_order: is_sales_order,
                    disable_qty_alert: disable_qty_alert,
                    is_draft: is_draft
                },
                dataType: 'json'
            }).done(function(res){
                if(!res || !res.success) {
                    if(window.console){ console.warn('Price refresh failed for variation', variation_id, 'group', groupId, res); }
                    return;
                }
                // Parse the returned row HTML to extract default prices
                var $tmp = $('<table>'+res.html_content+'</table>');
                var newInc = __read_number($tmp.find('input.pos_unit_price_inc_tax'));
                var newEx  = __read_number($tmp.find('input.pos_unit_price'));

                if(!isNaN(newInc)) {
                    var $inc = $row.find('input.pos_unit_price_inc_tax');
                    __write_number($inc, newInc);
                    $inc.attr('data-orig', __number_f(newInc));
                    $inc.trigger('change');
                }
                if($row.find('input.pos_unit_price').length && !isNaN(newEx)) {
                    var $ex = $row.find('input.pos_unit_price');
                    __write_number($ex, newEx);
                    $ex.attr('data-orig', __number_f(newEx));
                    $ex.trigger('change');
                }

                // Re-evaluate totals/taxes for the updated row
                pos_each_row($row);

                // ensure line subtotal reflects new unit price immediately
                try {
                    var qty = __read_number($row.find('input.pos_quantity, input.input_quantity').first());
                    if (!isNaN(qty)) {
                        var unitInc = __read_number($row.find('input.pos_unit_price_inc_tax'));
                        var line = (qty || 0) * (unitInc || 0);
                        __write_number($row.find('input.pos_line_total'), line);
                        var $subText = $row.find('span.pos_line_total_text');
                        if ($subText.length && typeof __number_f === 'function') {
                            $subText.text(__number_f(line));
                        }
                    }
                } catch (e) {}

                round_row_to_iraqi_dinnar($row);
                pos_total_row();
                __currency_convert_recursively($row);
            });
        }

        function onGroupChanged(){
            var groupId = $(this).val();
            // Update helper label if present
            var $txt = $('#price_group_text');
            if($txt.length){
                $txt.removeClass('hide');
                $txt.find('span').text($('#price_group option:selected').text() || '');
            }

            $('#pos_table tbody tr.product_row').each(function(){
                refreshRowPrice($(this), groupId);
            });
        }

        // Fire on native change and select2 events
        $(document).on('change', '#price_group', onGroupChanged);
        $(document).on('select2:select select2:clear', '#price_group', onGroupChanged);

        // If page loads with a preselected group, ensure prices match it
        $(function(){
            var initial = $('#price_group').val();
            if(initial){
                $('#pos_table tbody tr.product_row').each(function(){
                    refreshRowPrice($(this), initial);
                });
            }
        });
    })(jQuery);
    </script>
@endsection
